<?php

namespace Modules\BusinessManagement\Http\Controllers\Web\Admin\PagesMedia;

use App\Http\Controllers\BaseController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Http;
use Illuminate\View\View;
use Modules\BusinessManagement\Http\Requests\LandingBusinessStatisticsStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingCTAStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingEarnMoneyStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingIntroSectionStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingOurSolutionsIntroUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingOurSolutionsStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\LandingTestimonialStoreOrUpdateRequest;
use Modules\BusinessManagement\Service\Interface\BusinessSettingServiceInterface;

class LandingPageController extends BaseController
{
    protected $businessSettingService;

    public function __construct(BusinessSettingServiceInterface $businessSettingService)
    {
        parent::__construct($businessSettingService);
        $this->businessSettingService = $businessSettingService;
    }

    public function index(?Request $request, string $type = null): View|Collection|LengthAwarePaginator|null|callable|RedirectResponse
    {
        return parent::index($request, $type); // TODO: Change the autogenerated stub
    }

    public function introSection()
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => INTRO_SECTION, 'settings_type' => LANDING_PAGES_SETTINGS];
        $attributes1 = ['key_name' => INTRO_SECTION_IMAGE, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        $data1 = $this->businessSettingService->findOneBy(criteria: $attributes1);
        return view('businessmanagement::admin.pages.intro-section', compact('data', 'data1'));
    }

    public function updateIntroSection(LandingIntroSectionStoreOrUpdateRequest $request): RedirectResponse
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeLandingPageIntroSection($request->validated());
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function getOurSolutionsSectionView(Request $request): View
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => OUR_SOLUTIONS_SECTION, 'settings_type' => LANDING_PAGES_SETTINGS];
        $attributes1 = ['key_name' => OUR_SOLUTIONS_DATA, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        $ourSolutionList = $this->businessSettingService->getBy(criteria: $attributes1, limit: paginationLimit(), offset: $request->get('page', 1));

        return view('businessmanagement::admin.pages.our-solutions', [
            'data' => $data,
            'ourSolutionList' => $ourSolutionList,
        ]);
    }

    public function updateOurSolutions(LandingOurSolutionsIntroUpdateRequest $request): RedirectResponse
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeLandingPageOurSolutionsSection($request->validated());
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function getAddOrUpdateOurSolutions(LandingOurSolutionsStoreOrUpdateRequest $request): RedirectResponse
    {
        $this->authorize('business_edit');
        $data = $request->validated();
        if ($request->has('id')) {
            $data = array_merge($data, [
                'id' => $request['id']
            ]);
        }
        $this->businessSettingService->storeLandingPageOurSolutionsData($data);
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function statusOurSolutions(Request $request): JsonResponse
    {
        $this->authorize('business_edit');
        $model = $this->businessSettingService->statusChangeOurSolutions(id: $request['id'], data: $request->all());
        return response()->json($model);
    }

    public function editOurSolutions($id)
    {
        $this->authorize('business_view');
        $attributes = ['id' => $id, 'key_name' => OUR_SOLUTIONS_DATA, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        return view('businessmanagement::admin.pages.edit-our-solutions', compact('data'));
    }

    public function deleteOurSolutions($id): RedirectResponse
    {
        $this->authorize('business_edit');
        $this->businessSettingService->deleteOurSolutions(id: $id);
        Toastr::success(OUR_SOLUTION_DELETE_200['message']);
        return back();
    }


    public function businessStatistics()
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => BUSINESS_STATISTICS, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        return view('businessmanagement::admin.pages.business-statistics', compact('data'));
    }

    public function updateBusinessStatistics(LandingBusinessStatisticsStoreOrUpdateRequest $request)
    {
        $this->businessSettingService->storeLandingPageBusinessStatistics($request->validated());
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function ourPlatform()
    {
        return view('businessmanagement::admin.pages.our-platform');
    }

    public function updateOurPlatform(Request $request)
    {
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function earnMoney()
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => EARN_MONEY, 'settings_type' => LANDING_PAGES_SETTINGS];
        $attributes1 = ['key_name' => EARN_MONEY_IMAGE, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        $data1 = $this->businessSettingService->findOneBy(criteria: $attributes1);
        return view('businessmanagement::admin.pages.earn-money', compact('data', 'data1'));
    }

    public function updateEarnMoney(LandingEarnMoneyStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeLandingPageEarnMoney($request->validated());
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }

    public function testimonial(Request $request)
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => TESTIMONIAL, 'settings_type' => LANDING_PAGES_SETTINGS];
        $testimonials = $this->businessSettingService->getBy(criteria: $attributes, limit: paginationLimit(), offset: $request->get('page', 1));
        return view('businessmanagement::admin.pages.testimonial', compact('testimonials'));
    }

    public function updateTestimonial(LandingTestimonialStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $data = $request->validated();
        if ($request->has('id')) {
            $data = array_merge($data, [
                'id' => $request->id
            ]);
        }
        $this->businessSettingService->storeLandingPageTestimonial($data);
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return redirect()->route('admin.business.pages-media.landing-page.testimonial.index');
    }

    public function statusTestimonial(Request $request)
    {
        $this->authorize('business_edit');
        $model = $this->businessSettingService->statusChange(id: $request->id, data: $request->all());
        return response()->json($model);
    }

    public function editTestimonial($id)
    {
        $this->authorize('business_view');
        $attributes = ['id' => $id, 'key_name' => TESTIMONIAL, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        return view('businessmanagement::admin.pages.edit-testimonial', compact('data'));
    }

    public function deleteTestimonial($id)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->delete(id: $id);
        Toastr::success(TESTIMONIAL_DELETE_200['message']);
        return back();
    }

    public function cta()
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => CTA, 'settings_type' => LANDING_PAGES_SETTINGS];
        $attributes1 = ['key_name' => CTA_IMAGE, 'settings_type' => LANDING_PAGES_SETTINGS];
        $data = $this->businessSettingService->findOneBy(criteria: $attributes);
        $data1 = $this->businessSettingService->findOneBy(criteria: $attributes1);
        return view('businessmanagement::admin.pages.cta', compact('data', 'data1'));
    }

    public function updateCta(LandingCTAStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeLandingPageCTA($request->validated());
        $activationMode = externalConfig('activation_mode');
        $martBaseUrl = externalConfig('mart_base_url');
        if ($activationMode && $activationMode->value == 1 && $martBaseUrl && $martBaseUrl->value != null) {
            $name = businessConfig('business_name', BUSINESS_INFORMATION)?->value ?? "DriveMond";
            $logo = businessConfig('header_logo', BUSINESS_INFORMATION)?->value ? asset(businessConfig('header_logo', BUSINESS_INFORMATION)?->value) : dynamicAsset('public/assets/admin-module/img/logo.png');
            $cta = $this->businessSettingService->findOneBy(criteria: ['key_name' => CTA, 'settings_type' => LANDING_PAGES_SETTINGS]);

            try {
                $response = Http::post($martBaseUrl->value . '/api/v1/configurations/store', [
                    'drivemond_business_name' => $name,
                    'drivemond_business_logo' => $logo,
                    'drivemond_app_url_android' => $cta?->value && $cta?->value['play_store']['user_download_link'] ? $cta?->value['play_store']['user_download_link'] : "",
                    'drivemond_app_url_ios' => $cta?->value && $cta?->value['app_store']['user_download_link'] ? $cta?->value['app_store']['user_download_link'] : "",
                ]);
            } catch (\Exception $exception) {

            }
        }
        Toastr::success(LANDING_PAGE_UPDATE_200['message']);
        return back();
    }
}
