@extends('installation.layouts.master')
@section('title', 'Fourth Step')
@section('content')
    @include('installation.layouts.title')

    <!-- Progress -->
    <div class="pb-2">
        <div class="progress cursor-pointer" role="progressbar" aria-label="DriveMond Software Installation"
             aria-valuenow="80" aria-valuemin="0" aria-valuemax="100" data-bs-toggle="tooltip"
             data-bs-placement="top" data-bs-custom-class="custom-progress-tooltip" data-bs-title="Fourth Step!"
             data-bs-delay='{"hide":1000}'>
            <div class="progress-bar w-d" style="--width: 80%"></div>
        </div>
    </div>

    <!-- Card -->
    <div class="card mt-4 position-relative">
        <div class="d-flex justify-content-end mb-2 position-absolute top-end">
            <a href="#" class="d-flex align-items-center gap-1">
                        <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="custom-tooltip"
                              data-bs-title="Click on the section to automatically import database">

                            <img src="{{dynamicAsset('public/assets/installation/assets/img/svg-icons/info.svg')}}" alt=""
                                 class="svg">
                        </span>
            </a>
        </div>
        <div class="p-4 mb-md-3 mx-xl-4 px-md-5">
            <div class="d-flex align-items-center column-gap-3 flex-wrap">
                <h5 class="fw-bold fs text-uppercase">{{translate('Step 4.')}} </h5>
                <h5 class="fw-normal">{{translate('Import Database')}}</h5>
            </div>
            <p class="mb-5">
                {{translate('Your Database has been connected ! Just click on the section to automatically import database')}}
            </p>

            @if(session()->has('error'))
                <div class="row">
                    <div class="col-md-12">
                        <div class="alert alert-danger">
                            {{translate('Your database is not clean, do you want to clean database then import')}}?
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-center">
                    <a href="{{ route('force-import-sql') }}" class="btn btn-danger px-sm-5 loader-show">
                        {{translate('Force Import Database')}}</a>
                </div>
            @else
                <div class="d-flex justify-content-center">
                    <a href="{{ route('import_sql',['token'=>bcrypt('step_5')]) }}" class="btn btn-dark px-sm-5 loader-show">{{translate('Click Here')}}</a>
                </div>
            @endif


        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        "use strict";
        $(".loader-show").on('click',function (){
            $('#loading').fadeIn();
        });
    </script>
@endsection
